using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Xml;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.Linq;
using System.Linq.Expressions;

namespace PI.ZB.N1200.ELearning.WinForms.AdvancedLevel
{
    public partial class UCAdvancedLevelList : PI.FM.N000.Base.WinForms.Controls.UCBOList<BL.BO.AdvancedLevel, UCAdvancedLevelDetails, BL.BO.AdvancedLevel.Search>
    {
        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        private PI.FM.N005.VariableRepository.BL.VariableRepository _blVariableRepository = null;

        public UCAdvancedLevelList()
        {
            InitializeComponent();
        }

        protected PI.ZB.N1200.ELearning.BL.ZSBELearning BLZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blZSBELearning;
            }
        }

        internal PI.FM.N005.VariableRepository.BL.VariableRepository BLVariableRepository
        {
            get
            {
                if (_blVariableRepository == null)
                {
                    _blVariableRepository = new PI.FM.N005.VariableRepository.BL.VariableRepository(Environment);
                }

                return _blVariableRepository;
            }
        }

        protected override void InitAll()
        {
            base.InitAll();
            
            DataManager.AllowedActions = Gemini.Core.WinForms.Controls.Type.ControlActionType.Refresh | Gemini.Core.WinForms.Controls.Type.ControlActionType.RefreshCurrent |  Gemini.Core.WinForms.Controls.Type.ControlActionType.Save;
            DataManager.InitColumns(new string[] { "ID", "Name", "From", "To", "ChangeFrom", "ChangeTo" });//Przetumaczone
            DataManager.ColumnCaptions = new string[] { Gemini.Dictionary.Text.Grid.ID.Value, Gemini.Dictionary.Text.Grid.Name.Value, BL.Dictionary.Text.Grid.EvaluationSheet.From.Value, BL.Dictionary.Text.Grid.EvaluationSheet.To.Value, BL.Dictionary.Text.Grid.EvaluationSheet.From.Value, BL.Dictionary.Text.Grid.EvaluationSheet.To.Value };
        }

        protected override IList<BL.BO.AdvancedLevel> OnLoadData(Gemini.Core.WinForms.Controls.GDataManagerArgs Args)
        {
            DataManager.TotalCount = BLZSBELearning.AdvancedLevel.Count();

            return BLZSBELearning.AdvancedLevel.Restore();
        }

        protected override BL.BO.AdvancedLevel OnCreate(Gemini.Core.WinForms.Controls.GDataManagerArgs Args)
        {
            return null;
        }

        protected override BL.BO.AdvancedLevel DoRestoreCurrent(Gemini.Core.BL.Interface.BO.IBaseUnique<long?> BO)
        {
            return BLZSBELearning.AdvancedLevel.Restore(BO);
        }

        public override void DialogResultOK()
        {
            Param.Object = DataManager.Current;
            Param.ObjectTitle = DataManager.Current.DisplayValue;
            Param.ObjectID = DataManager.Current.ID;
            Param.IsObjectValid = true;
            Param.ClientID = BLZSBELearning.ClientID;
            Param.ObjectList = DataManager.GetSelectedObjects().Select(x => (FM.N000.Base.BL.BO.Base)x).ToList();
        }

        protected override void OnSave(Gemini.Core.WinForms.Controls.GDataManagerArgs<BL.BO.AdvancedLevel> Args)
        {
            if (Args.Object != null)
            {
                DetailsView.Save();
                DataManager.LoadData();
            }
        }
    }
}
